<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package ozenera-church
 * @since 1.0.0
 */ 

/**
 * Enqueue the CSS files.
 *
 * @since 1.0.0
 *
 * @return void
 */
function ozenera_church_styles() {
	wp_enqueue_style(
		'ozenera-church-style',
		get_stylesheet_uri(),
		[],
		wp_get_theme()->get( 'Version' )
	);
}
add_action( 'wp_enqueue_scripts', 'ozenera_church_styles' );

/*-------------------------------------------------------------
 Enqueue Styles
--------------------------------------------------------------*/

if ( ! function_exists( 'ozenera_church_styles' ) ) :	
	function ozenera_church_styles() {
		// Register theme stylesheet.
		wp_enqueue_style('ozenera-church-style', get_stylesheet_uri(), array(), wp_get_theme()->get('version') );
		wp_enqueue_style('ozenera-church-style-blocks', get_template_directory_uri(). '/assets/css/blocks.css');
	}

endif;
add_action( 'wp_enqueue_scripts', 'ozenera_church_styles' );

// Theme customizer
require_once get_theme_file_path( '/inc/customizer.php' );	

function ozenera_church_register_block_pattern_categories(){
    register_block_pattern_category(
        'ozenera-church',
        array( 'label' => __( 'OzenEra Church Theme Patterns', 'ozenera-church' ) )
    );

}
add_action('init', 'ozenera_church_register_block_pattern_categories');

/**
 * Include the Customizer CSS
 */
add_action( 'admin_enqueue_scripts', 'load_admin_styles' );
function load_admin_styles() {
    wp_enqueue_style( 'ozenera-church-admin-css', get_template_directory_uri() . '/assets/css/ozen-admin.css', false, '1.0.0' );
}